/* PRICE MODEL*/
/* Projects vehicle operating costs relating to fuel prices and taxes based*/
/* on scenarios for the world oil price and assumptions about tax rates. */
/* Also calculates vehicle prices as a function of NZ exchange rate*/
/* assumptions.*/
/* CPI is average all group consumers price index (RBNZ).*/
/* Petrol and diesel "base prices" are import prices including freight.*/
/* Petrol and diesel taxes are unit charges e.g. excise and levies. They*/
/* include non-NLTF taxes.*/

/* Note on results: the projections are highly sensitive on the assumed projection based of petrol_imp_margin_rate[i] = diesel_imp_margin_rate[History_length-2,.]. Further sensitivity testing will be required */

/*DEVELOPMENT NOTES (TBC): (i) refine within model global variations so that*/
/*they are sub-model specific e.f. Projection length replaced by PL_price.*/
mata
/* DIMENSIONS*/
/*Projection length, periods*/
Ps = 2021
Pe = 2050
/*Length of historical data series*/
Ts = 1992
Te = 2020
/*Set population series length, history plus projection*/
Time_length = Pe - Ts + 1
TL = Time_length

/*Length of history*/
/*History_length = length(History_t)*/
History_length = Te - Ts+1
HL = History_length

/*Length of projection*/
/*Projection_length = length(Projection_t)*/
Projection_length = Pe - Ps + 1

/* PARAMETERS ASSUMPTIONS*/
/* random component of oil price*/
/* random component of exchange rate*/
oil_e = rnormal(TL,1,0,oil_e_stdev) 
nzd_usd_er_e = rnormal(TL,1,0,nzd_usd_er_e_stdev) 


/* INITIALISE*/
/* Calculate margins and rates*/

/* (i) Fuel prices*/
diesel_imp_margin_rate = (diesel_imp_margin:/diesel_base_price\J(Projection_length,1,0))
petrol_imp_margin_rate = (petrol_imp_margin:/petrol_base_price\J(Projection_length,1,0))
diesel_taxes_proj = (diesel_taxes\J(Projection_length,1,0))
petrol_taxes_proj = (petrol_taxes\J(Projection_length,1,0))
diesel_ets_cost_proj = (diesel_ets_cost\J(Projection_length,1,0))
petrol_ets_cost_proj = (petrol_ets_cost\J(Projection_length,1,0))
diesel_base_price_proj = (diesel_base_price\J(Projection_length,1,0))
petrol_base_price_proj = (petrol_base_price\J(Projection_length,1,0))
diesel_pump_price_proj = (diesel_pump_price\J(Projection_length,1,0))
petrol_pump_price = (petrol_pump_price\J(Projection_length,1,0))
nzd_oil_price_growth = J(TL,1,0)
petrol_pump_price_growth = J(TL,1,0)
vehicle_price_proj_growth = J(TL,1,0)
vehicle_price_proj_r_growth = J(TL,1,0)
petrol_pump_price_r_growth = J(TL,1,0)
cpi_index_growth = J(TL,1,0)
elec_base_price_proj = (J(History_length,1,elec_price_initial)\J(Projection_length,1,0))


/* (ii) Macro variables*/
oil_price_proj = (oil_price_usd\J(Projection_length,1,0))
nzd_usd_er_proj = (nz_usd_er\J(Projection_length,1,0))
gst_proj = (gst\J(Projection_length,1,0))
cpi_proj = (cpi\J(Projection_length,1,0))
fuel_price_cpi_proj = (fuel_price_cpi\J(Projection_length,1,0))


/* (iii) Vehicle prices*/
vehicle_price_proj = (vehicle_price\J(Projection_length,1,0))


/* PROJECTIONS*/
/* vehicle_price_proj may look curious at first glance but it is very roughly in keeping with the connection between CPI and lr ERs, i.e. high CPI = low ER = higher prices.*/

for (i=History_length+1; i<=TL; i++) {
    cpi_proj[i] = cpi_proj[i-1]:*(1:+cpi_growth)
    diesel_imp_margin_rate[i] = diesel_imp_margin_rate[History_length-2,.]
    petrol_imp_margin_rate[i] = diesel_imp_margin_rate[History_length-2,.]
    
    if (specify_tax == 1) {        
        diesel_taxes_proj[i] = diesel_taxes_proj[i-1]:*(1:+diesel_tax_track[i-1])
        petrol_taxes_proj[i] = petrol_taxes_proj[i-1]:*(1:+petrol_tax_track[i-1])
    }
else{
        diesel_taxes_proj[i] = diesel_taxes_proj[i-1]:*(1:+diesel_tax_growth)
        petrol_taxes_proj[i] = petrol_taxes_proj[i-1]:*(1:+petrol_tax_growth)
    }	
    
    diesel_ets_cost_proj[i] = diesel_ets_cost_proj[i-1]:*(1:+ets_cost_growth)
    petrol_ets_cost_proj[i] = petrol_ets_cost_proj[i-1]:*(1:+ets_cost_growth)
    
    oil_price_proj[i]=oil_price_proj[i-1]+(oil_price_lr:-oil_price_proj[i-1]):/oil_price_lr_smooth
    
    oil_price_proj[i] = oil_price_proj[i]:*(1:+oil_e[i])
    
    nzd_usd_er_proj[i] = nzd_usd_er_proj[i-1]+(nzd_usd_er_lr - nzd_usd_er_proj[i-1]):/nzd_usd_er_smooth
    
    nzd_usd_er_proj[i] = nzd_usd_er_proj[i]:*(1:+nzd_usd_er_e[i])
    
    gst_proj[i] = gst_constant
    
    vehicle_price_proj[i] =  vehicle_price_proj[i-1]:*(1:+cpi_growth) 
}

oil_price_proj_r = oil_price_proj:/cpi_proj
nzd_oil_price_proj = oil_price_proj:/nzd_usd_er_proj
nzd_oil_price_growth[2..rows(nzd_oil_price_growth)] = diff(nzd_oil_price_proj):/nzd_oil_price_proj[1..rows(nzd_oil_price_proj)-1]
vehicle_price_proj_r = vehicle_price_proj:/cpi_proj
vehicle_price_proj_growth[2..rows(vehicle_price_proj_growth)] = diff(vehicle_price_proj):/vehicle_price_proj[1..rows(vehicle_price_proj)-1] 
vehicle_price_proj_r_growth[2..rows(vehicle_price_proj_r_growth)] = diff(vehicle_price_proj_r):/vehicle_price_proj_r[1..rows(vehicle_price_proj_r)-1]


for (i=History_length+1; i<=TL; i++){
    diesel_base_price_proj[i] = diesel_base_price_proj[i-1]:*(1:+nzd_oil_price_growth[i])
    petrol_base_price_proj[i] = petrol_base_price_proj[i-1]:*(1:+nzd_oil_price_growth[i])
    elec_base_price_proj[i] = elec_base_price_proj[i-1]:*(1:+elec_price_growth+cpi_growth) 
}


diesel_pump_price_proj = ((diesel_base_price_proj:*(1:+ diesel_imp_margin_rate))+ diesel_taxes_proj + diesel_ets_cost_proj):*(1:+gst_proj)
petrol_pump_price_proj = ((petrol_base_price_proj:*(1:+ petrol_imp_margin_rate))+ petrol_taxes_proj + petrol_ets_cost_proj):*(1:+gst_proj)

petrol_pump_price_growth[2..rows(petrol_pump_price_growth)] = diff(petrol_pump_price_proj):/petrol_pump_price_proj[1..rows(petrol_pump_price_proj)-1]

for (i=History_length+1; i<=TL; i++) {
fuel_price_cpi_proj[i] = fuel_price_cpi_proj[i-1]:*(1:+petrol_pump_price_growth[i])
}

price_to_gdp = (fuel_price_cpi_proj:/gdp_percapita)/1000
petrol_pump_price_growth[2..rows(petrol_pump_price_growth)] = diff(petrol_pump_price_proj):/petrol_pump_price_proj[1..rows(petrol_pump_price_proj)-1]

cpi_index_growth[2..rows(cpi_index_growth)] = diff(cpi_proj):/cpi_proj[1..rows(cpi_proj)-1]    

petrol_pump_price_r_growth = petrol_pump_price_growth-cpi_index_growth

petrol_pump_price_proj_r = petrol_pump_price_proj:/cpi_proj

/*Oil + ER, Margin, Tax, ETS, GST*/
petrol_price_decomp = (petrol_base_price_proj, petrol_base_price_proj:*petrol_imp_margin_rate, petrol_taxes_proj, petrol_ets_cost_proj, petrol_pump_price_proj - (petrol_pump_price_proj:/(1:+gst_proj))) 
/*Oil + ER, Margin, Tax, ETS, GST*/
diesel_price_decomp = (diesel_base_price_proj, diesel_base_price_proj:*diesel_imp_margin_rate, diesel_taxes_proj, diesel_ets_cost_proj, diesel_pump_price_proj - (diesel_pump_price_proj:/(1:+gst_proj))) 
    
end
